// Charts
function renderCharts() {
    horizontalBarChart();
    doughnutChart();
    lineChart();
    barChart();
    pieChart();
    polarChart();
    radarChart();
    bubbleChart();
}

const isChartElement = (element) => {
    return element ? element.tagName.toLowerCase() === 'canvas' : false
}

// Horizontal Bar Chart
function horizontalBarChart() {
    let element = document.getElementById('horizontal-bar-chart')
    if (isChartElement(element)) {
        let horizontalBar = element.getContext('2d');
        let chart = new Chart(horizontalBar, {
            type: 'horizontalBar',

            data: {
                labels: [
                    'Permanent',
                    'Provision',
                    'Terminated',
                    'Intern',
                    'Canceled'
                ],
                datasets: [{
                    borderWidth: 1,
                    barThickness: 25,
                    barPercentage: 0.5,
                    backgroundColor: 'rgb(68, 102, 242)',
                    borderColor: 'rgb(68, 102, 242)',
                    data: [44, 41, 27, 25, 14]
                }]
            },

            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                    }
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}

// Line Chart
function lineChart() {
    let element = document.getElementById('line-chart')
    if (isChartElement(element)) {
        let line = element.getContext('2d');
        let chart = new Chart(line, {
            type: 'line',

            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [
                    {
                        label: 'Attendance',
                        backgroundColor: 'rgb(70, 195, 95)',
                        borderColor: 'rgb(70, 195, 95)',
                        data: [0, 100, 80, 120, 90, 200, 50],
                        fill: false,
                    },
                    {
                        label: 'Leave',
                        fill: false,
                        backgroundColor: 'rgb(252, 101, 16)',
                        borderColor: 'rgb(252, 101, 16)',
                        data: [10, 120, 30, 190, 5, 240, 50],
                    }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}

// Bar Chart
function barChart() {
    let element = document.getElementById('bar-chart')
    if (isChartElement(element)) {
        let bar = element.getContext('2d');
        let chart = new Chart(bar, {
            type: 'bar',

            data: {
                labels: [
                    'Alison',
                    'Kimberly',
                    'Sophie',
                    'Amy',
                    'Tracey'
                ],
                datasets: [{
                    borderWidth: 1,
                    barThickness: 25,
                    barPercentage: 0.5,
                    backgroundColor: 'rgb(68, 102, 242)',
                    borderColor: 'rgb(68, 102, 242)',
                    data: [80, 85, 60, 65, 90]
                }]
            },

            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                    }
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}


// Doughnut Chart
function doughnutChart() {
    let element = document.getElementById('doughnut-chart')
    if (isChartElement(element)) {
        let doughnut = element.getContext('2d');
        let chart = new Chart(doughnut, {
            type: 'doughnut',

            data: {
                datasets: [{
                    borderWidth: 0,
                    data: [
                        200,
                        650,
                        350
                    ],
                    backgroundColor: [
                        'rgb(252, 44, 16)',
                        'rgb(70, 195, 95)',
                        'rgb(252, 101, 16)'
                    ]
                }],
                labels: [
                    'Early',
                    'Regular',
                    'Late'
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        });
    }
}

// Pie Chart
function pieChart() {
    let element = document.getElementById('pie-chart')
    if (isChartElement(element)) {
        let pie = element.getContext('2d');
        let chart = new Chart(pie, {
            type: 'pie',

            data: {
                labels: ['VueJs', 'EmberJs', 'ReactJs', 'AngularJs'],
                datasets: [
                    {
                        borderWidth: 0,
                        backgroundColor: ['#f96868', '#4466F2', '#2e383e', '#6a008a'],
                        data: [20, 25, 40, 15]
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        })
    }
}

// Polar Chart
function polarChart() {
    let element = document.getElementById('polar-chart')
    if (isChartElement(element)) {
        let polar = element.getContext('2d');
        let chart = new Chart(polar, {
            type: 'polarArea',

            data: {
                labels: ['Eating', 'Drinking', 'Sleeping', 'Designing', 'Coding', 'Cycling', 'Running'],
                datasets: [
                    {
                        borderWidth: 0,
                        backgroundColor: ['#4466F2', '#f96868', '#2e383e', '#6a008a', '#008000', '#FFFF00', '#00008B'],
                        data: [65, 59, 76, 70, 56, 55, 40]
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        })
    }
}


// Radar Chart
function radarChart() {
    let element = document.getElementById('radar-chart')
    if (isChartElement(element)) {
        let radar = element.getContext('2d');
        let chart = new Chart(radar, {
            type: 'radar',

            data: {
                labels: ['Eating', 'Drinking', 'Sleeping', 'Designing', 'Coding', 'Cycling', 'Running'],
                datasets: [
                    {
                        borderWidth: 0,
                        label: 'Data one',
                        backgroundColor: 'rgba(68, 102, 242, 0.5)',
                        borderColor: 'rgba(179,181,198,.5)',
                        pointBackgroundColor: 'rgba(70, 195, 95, 1)',
                        pointBorderColor: '#fff',
                        pointHoverBackgroundColor: '#fff',
                        pointHoverBorderColor: 'rgba(179,181,198,1)',
                        data: [65, 59, 90, 81, 56, 55, 40]
                    },
                    {
                        borderWidth: 0,
                        label: 'Data two',
                        backgroundColor: 'rgba(106, 0, 138, 0.5)',
                        borderColor: 'rgba(0, 143, 214, .5)',
                        pointBackgroundColor: 'rgba(70, 195, 95, 1)',
                        pointBorderColor: '#fff',
                        pointHoverBackgroundColor: '#fff',
                        pointHoverBorderColor: 'rgba(255,99,132,1)',
                        data: [28, 48, 40, 19, 96, 27, 100]
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif'
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif'
                        }
                    }]
                }
            }
        })
    }
}


// Bubble Chart
function bubbleChart() {
    let element = document.getElementById('bubble-chart')
    if (isChartElement(element)) {
        let bubble = element.getContext('2d');
        let chart = new Chart(bubble, {
            type: 'bubble',

            data: {
                labels: ['Eating', 'Drinking', 'Sleeping', 'Designing', 'Coding', 'Cycling', 'Running'],
                datasets: [
                    {
                        label: 'Data One',
                        backgroundColor: '#4466F2',
                        data: [
                            {
                                x: 20,
                                y: 25,
                                r: 5
                            },
                            {
                                x: 40,
                                y: 10,
                                r: 10
                            },
                            {
                                x: 30,
                                y: 22,
                                r: 30
                            }
                        ]
                    },
                    {
                        label: 'Data Two',
                        backgroundColor: '#6a008a',
                        data: [
                            {
                                x: 10,
                                y: 30,
                                r: 15
                            },
                            {
                                x: 20,
                                y: 20,
                                r: 10
                            },
                            {
                                x: 15,
                                y: 16,
                                r: 30
                            }
                        ]
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif'
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif'
                        }
                    }]
                }
            }
        })
    }
}
