// Charts
function renderCharts() {
    employeeStatisticsChart();
    todayOverviewChart();
    leaveAttendanceSummeryChart();
    topEmployeesChart();
}

const isChartElement = (element) => {
    return element ? element.tagName.toLowerCase() === 'canvas' : false
}

// Employee Statistics Chart
function employeeStatisticsChart() {
    let element = document.getElementById('employeeStatistics')
    if (isChartElement(element)) {
        let employeeStatisticsChart = element.getContext('2d');
        let chart = new Chart(employeeStatisticsChart, {
            type: 'horizontalBar',

            data: {
                labels: [
                    'Permanent',
                    'Provision',
                    'Terminated',
                    'Intern',
                    'Canceled'
                ],
                datasets: [{
                    borderWidth: 1,
                    barThickness: 25,
                    barPercentage: 0.5,
                    backgroundColor: '#36A0F7',
                    borderColor: '#36A0F7',
                    data: [44, 41, 27, 25, 14]
                }]
            },

            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                    }
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}

// Today Overview Chart
function todayOverviewChart() {
    let element = document.getElementById('todayEmployeeOverview')
    if(isChartElement(element)) {
        let todayOverviewChart = element.getContext('2d');
        let chart = new Chart(todayOverviewChart, {
            type: 'doughnut',

            data: {
                datasets: [{
                    borderWidth: 0,
                    data: [
                        200,
                        650,
                        350
                    ],
                    backgroundColor: [
                        'rgb(252, 44, 16)',
                        'rgb(70, 195, 95)',
                        'rgb(252, 101, 16)'
                    ]
                }],
                labels: [
                    'Early',
                    'Regular',
                    'Late'
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        });
    }
}

// Leave Attendance Summery Chart
function leaveAttendanceSummeryChart() {
    let element = document.getElementById('leaveAttendanceSummery')
    if(isChartElement(element)) {
        let leaveAttendanceSummeryChart = element.getContext('2d');
        let chart = new Chart(leaveAttendanceSummeryChart, {
            type: 'line',

            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [
                    {
                        backgroundColor: 'rgb(70, 195, 95)',
                        borderColor: 'rgb(70, 195, 95)',
                        data: [0, 100, 80, 120, 90, 200, 50],
                        fill: false,
                    },
                    {
                        fill: false,
                        backgroundColor: 'rgb(252, 101, 16)',
                        borderColor: 'rgb(252, 101, 16)',
                        data: [10, 120, 30, 190, 5, 240, 50],
                    }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}

// Top Employees Chart
function topEmployeesChart() {
    let element = document.getElementById('topEmployees')
    if(isChartElement(element)) {
        let topEmployeesChart = element.getContext('2d');
        let chart = new Chart(topEmployeesChart, {
            type: 'bar',

            data: {
                labels: [
                    'Alison',
                    'Kimberly',
                    'Sophie',
                    'Amy',
                    'Tracey'
                ],
                datasets: [{
                    borderWidth: 1,
                    barThickness: 25,
                    barPercentage: 0.5,
                    backgroundColor: 'rgb(68, 102, 242)',
                    borderColor: 'rgb(68, 102, 242)',
                    data: [80, 85, 60, 65, 90]
                }]
            },

            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                    }
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}
