function renderCharts() {
    weeklySalesChartWidget();
    teamProgressChartWidget();
    weeklyIncomeChartWidget();
    yearlyEarningsChartWidget();
    profitLossSummeryChartChart();
    attendanceSummeryChart();
    projectSummeryChart();
}

const isChartElement = (element) => {
    return element ? element.tagName.toLowerCase() === 'canvas' : false
}

// Weekly Sales Chart Widget
function weeklySalesChartWidget() {
    let element = document.getElementById('weeklySalesChartWidget');

    if (isChartElement(element)) {
        let weeklySalesChartWidget = element.getContext('2d');
        let chart = new Chart(weeklySalesChartWidget, {
            type: 'line',
            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [{
                    borderColor: '#4466F2',
                    pointBackgroundColor: '#4466F2',
                    backgroundColor: 'rgba(68, 102, 242, 0.2)',
                    data: [15, 25, 20, 26, 22, 40, 35]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Team Progress Chart Widget
function teamProgressChartWidget() {
    let element = document.getElementById('teamProgressChartWidget');

    if (isChartElement(element)) {
        let teamProgressChartWidget = element.getContext('2d');
        let chart = new Chart(teamProgressChartWidget, {
            type: 'line',
            data: {
                labels: ['Design', 'Development', 'Marketing', 'HR'],
                datasets: [{
                    borderColor: '#46c35f',
                    pointBackgroundColor: '#46c35f',
                    backgroundColor: 'rgba(70, 195, 95, 0.2)',
                    data: [20, 15, 35, 25]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Weekly Income Chart Widget
function weeklyIncomeChartWidget() {
    let element = document.getElementById('weeklyIncomeChartWidget');

    if (isChartElement(element)) {
        let weeklyIncomeChartWidget = element.getContext('2d');
        let chart = new Chart(weeklyIncomeChartWidget, {
            type: 'line',
            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [{
                    borderColor: '#38a4f8',
                    pointBackgroundColor: '#38a4f8',
                    backgroundColor: 'rgba(56, 164, 248, 0.2)',
                    data: [20, 15, 35, 25, 25, 30, 19]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Yearly Earnings Chart Widget
function yearlyEarningsChartWidget() {
    let element = document.getElementById('yearlyEarningsChartWidget');

    if (isChartElement(element)) {
        let yearlyEarningsChartWidget = element.getContext('2d');
        let chart = new Chart(yearlyEarningsChartWidget, {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                    borderColor: '#FC6510',
                    pointBackgroundColor: '#FC6510',
                    backgroundColor: 'rgba(252, 101, 16, 0.2)',
                    data: [20, 15, 35, 25, 25, 30, 19, 20, 20, 30, 15, 30]
                },]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            beginAtZero: true
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawTicks: false
                        },
                        ticks: {
                            display: false,
                            suggestedMin: 0,
                            suggestedMax: 50,
                            beginAtZero: true
                        }
                    }]
                },
            }
        });
    }
}

// Leave Attendance Summery Chart
function profitLossSummeryChartChart() {
    let element = document.getElementById('profitLossSummeryChart')
    if(isChartElement(element)) {
        let profitLossSummeryChart = element.getContext('2d');
        let chart = new Chart(profitLossSummeryChart, {
            type: 'line',
            data: {
                labels: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                datasets: [
                    {
                        backgroundColor: 'rgb(70, 195, 95)',
                        borderColor: 'rgb(70, 195, 95)',
                        data: [0, 100, 80, 120, 90, 200, 50],
                        fill: false,
                    },
                    {
                        fill: false,
                        backgroundColor: 'rgb(252, 101, 16)',
                        borderColor: 'rgb(252, 101, 16)',
                        data: [10, 120, 30, 190, 5, 240, 50],
                    }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: xAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 12,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            drawTicks: false,
                            color: yAxisColor,
                            borderDash: [8, 4],
                            zeroLineBorderDash: [8, 4]
                        },
                        ticks: {
                            padding: 14,
                            lineHeight: 1.5,
                            fontSize: 11.262,
                            fontColor: '#9397A0',
                            fontFamily: '\'Poppins\', sans-serif',
                            beginAtZero: true,
                            suggestedMin: 0,
                            suggestedMax: 100
                        }
                    }]
                }
            }
        });
    }
}

// Attendance Summery Chart
function attendanceSummeryChart() {
    let element = document.getElementById('attendanceSummeryChart')
    if(isChartElement(element)) {
        let attendanceSummeryChart = element.getContext('2d');
        let chart = new Chart(attendanceSummeryChart, {
            type: 'doughnut',
            data: {
                datasets: [{
                    borderWidth: 0,
                    data: [
                        200,
                        650,
                        350
                    ],
                    backgroundColor: [
                        'rgb(252, 44, 16)',
                        'rgb(70, 195, 95)',
                        'rgb(252, 101, 16)'
                    ]
                }],
                labels: [
                    'Early',
                    'Regular',
                    'Late'
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        });
    }
}

// Project Summery Chart
function projectSummeryChart() {
    let element = document.getElementById('projectSummeryChart')
    if(isChartElement(element)) {
        let projectSummeryChart = element.getContext('2d');
        let chart = new Chart(projectSummeryChart, {
            type: 'pie',
            data: {
                datasets: [{
                    borderWidth: 0,
                    data: [
                        200,
                        650,
                        350,
                        350,
                    ],
                    backgroundColor: [
                        'rgb(252, 44, 16)',
                        'rgb(70, 195, 95)',
                        'rgb(252, 101, 16)',
                        'rgb(56, 164, 248)',
                    ]
                }],
                labels: [
                    'HRM',
                    'CRM',
                    'POS',
                    'Booking'
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                legend: {
                    display: false,
                },
                animation: {
                    animateScale: true,
                    animateRotate: true
                }
            }
        });
    }
}
