$(function () {
    // With a basic message
    $('#btnFireSweetAlert1').on('click', () => {
        Swal.fire(
            'Good job!',
            'You clicked the button!',
            'success'
        )
    });

    // A title with a text under
    $('#btnFireSweetAlert2').on('click', () => {
        Swal.fire(
            'The Internet?',
            'That thing is still around?',
            'question'
        )
    });

    // A modal with a title, an error icon, a text, and a footer
    $('#btnFireSweetAlert3').on('click', () => {
        Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Something went wrong!',
            footer: `<a href>Why do I have this issue?</a>`
        })
    });

    // A modal window with a long content inside
    $('#btnFireSweetAlert4').on('click', () => {
        Swal.fire({
            imageUrl: 'https://placeholder.pics/svg/300x1000',
            imageHeight: 1000,
            imageAlt: 'A tall image'
        })
    });

    // Custom HTML description and buttons with ARIA labels
    $('#btnFireSweetAlert5').on('click', () => {
        Swal.fire({
            title: `<strong>HTML <u>example</u></strong>`,
            icon: 'info',
            html: `You can use <b>bold text</b>, <a href="//sweetalert2.github.io">links</a> and other HTML tags`,
            showCloseButton: true,
            showCancelButton: true,
            focusConfirm: false,
            confirmButtonText: `<i class="fa fa-thumbs-up"></i> Great!`,
            confirmButtonAriaLabel: 'Thumbs up, great!',
            cancelButtonText: `<i class="fa fa-thumbs-down"></i>`,
            cancelButtonAriaLabel: 'Thumbs down'
        })
    });

    // A dialog with three buttons
    $('#btnFireSweetAlert6').on('click', () => {
        Swal.fire({
            title: 'Do you want to save the changes?',
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: `Save`,
            denyButtonText: `Don't save`,
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {
                Swal.fire('Saved!', '', 'success')
            } else if (result.isDenied) {
                Swal.fire('Changes are not saved', '', 'info')
            }
        })
    });

    // A custom positioned dialog
    $('#btnFireSweetAlert7').on('click', () => {
        Swal.fire({
            position: 'top-end',
            icon: 'success',
            title: 'Your work has been saved',
            showConfirmButton: false,
            timer: 1500
        })
    });

    // Custom animation with Animate.css
    $('#btnFireSweetAlert8').on('click', () => {
        Swal.fire({
            title: 'Custom animation with Animate.css',
            showClass: {
                popup: 'animate__animated animate__fadeInDown'
            },
            hideClass: {
                popup: 'animate__animated animate__fadeOutUp'
            }
        })
    });

    // A confirm dialog, with a function attached to the "Confirm"-button...
    $('#btnFireSweetAlert9').on('click', () => {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire(
                    'Deleted!',
                    'Your file has been deleted.',
                    'success'
                )
            }
        })
    });

    // By passing a parameter, you can execute something else for "Cancel"
    $('#btnFireSweetAlert10').on('click', () => {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success ml-2',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: false
        })

        swalWithBootstrapButtons.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'No, cancel!',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                swalWithBootstrapButtons.fire(
                    'Deleted!',
                    'Your file has been deleted.',
                    'success'
                )
            } else if (
                /* Read more about handling dismissals below */
                result.dismiss === Swal.DismissReason.cancel
            ) {
                swalWithBootstrapButtons.fire(
                    'Cancelled',
                    'Your imaginary file is safe :)',
                    'error'
                )
            }
        })
    });

    // A message with a custom image
    $('#btnFireSweetAlert11').on('click', () => {
        Swal.fire({
            title: 'Sweet!',
            text: 'Modal with a custom image.',
            imageUrl: 'https://unsplash.it/400/200',
            imageWidth: 400,
            imageHeight: 200,
            imageAlt: 'Custom image',
        })
    });

    // A message with custom width, padding, background and animated Nyan Cat
    $('#btnFireSweetAlert12').on('click', () => {
        Swal.fire({
            title: 'Custom width, padding, background.',
            width: 600,
            padding: '3em',
            background: '#fff url(https://sweetalert2.github.io/images/trees.png)',
            backdrop: `rgba(0,0,123,0.4) url('https://sweetalert2.github.io/images/nyan-cat.gif') left top no-repeat`
        })
    });

    // A message with auto close timer
    $('#btnFireSweetAlert13').on('click', () => {
        let timerInterval
        Swal.fire({
            title: 'Auto close alert!',
            html: 'I will close in <b></b> milliseconds.',
            timer: 2000,
            timerProgressBar: true,
            didOpen: () => {
                Swal.showLoading()
                timerInterval = setInterval(() => {
                    const content = Swal.getContent()
                    if (content) {
                        const b = content.querySelector('b')
                        if (b) {
                            b.textContent = Swal.getTimerLeft()
                        }
                    }
                }, 100)
            },
            willClose: () => {
                clearInterval(timerInterval)
            }
        }).then((result) => {
            /* Read more about handling dismissals below */
            if (result.dismiss === Swal.DismissReason.timer) {
                console.log('I was closed by the timer')
            }
        })
    });

    // Right-to-left support for Arabic, Persian, Hebrew, and other RTL languages
    $('#btnFireSweetAlert14').on('click', () => {
        Swal.fire({
            title: 'هل تريد الاستمرار؟',
            icon: 'question',
            iconHtml: '؟',
            confirmButtonText: 'نعم',
            cancelButtonText: 'لا',
            showCancelButton: true,
            showCloseButton: true
        })
    });

    // AJAX request example
    $('#btnFireSweetAlert15').on('click', () => {
        Swal.fire({
            title: 'Submit your Github username',
            input: 'text',
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Look up',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`//api.github.com/users/${login}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: `${result.value.login}'s avatar`,
                    imageUrl: result.value.avatar_url
                })
            }
        })
    });

    // Chaining modals (queue) example
    $('#btnFireSweetAlert16').on('click', () => {
        Swal.mixin({
            input: 'text',
            confirmButtonText: 'Next &rarr;',
            showCancelButton: true,
            progressSteps: ['1', '2', '3']
        }).queue([
            {
                title: 'Question 1',
                text: 'Chaining swal2 modals is easy'
            },
            'Question 2',
            'Question 3'
        ]).then((result) => {
            if (result.value) {
                const answers = JSON.stringify(result.value)
                Swal.fire({
                    title: 'All done!',
                    html: `
        Your answers:
        <pre><code>${answers}</code></pre>
      `,
                    confirmButtonText: 'Lovely!'
                })
            }
        })
    });

    // Dynamic queue example
    $('#btnFireSweetAlert17').on('click', () => {
        const ipAPI = '//api.ipify.org?format=json'

        Swal.queue([{
            title: 'Your public IP',
            confirmButtonText: 'Show my public IP',
            text:
                'Your public IP will be received ' +
                'via AJAX request',
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return fetch(ipAPI)
                    .then(response => response.json())
                    .then(data => Swal.insertQueueStep(data.ip))
                    .catch(() => {
                        Swal.insertQueueStep({
                            icon: 'error',
                            title: 'Unable to get your public IP'
                        })
                    })
            }
        }])
    });
});