$(function () {
    "use strict";
    // bootstrap toaster
    $('.bs-toast-btn').on('click', (e) => {
        let toastId = e.target.dataset.target
        if (toastId) $(`#${toastId}`).toast('show')
    });

    // toastr js - Options
    toastr.options = {
        closeButton: false,
        debug: false,
        newestOnTop: false,
        progressBar: true,
        positionClass: 'toast-top-right',
        preventDuplicates: false,
        onclick: null,
        showDuration: 1000,
        hideDuration: 1000,
        timeOut: 2000,
        extendedTimeOut: 2000,
        showEasing: 'swing',
        hideEasing: 'linear',
        showMethod: 'fadeIn',
        hideMethod: 'fadeOut'
    }
    toastr.options.rtl = localStorage.getItem('layout') === 'rtl'

    // Position change and toast
    $('.toastr-btn').on('click', (e) => {
        let position = e.target.dataset.position;
        toastr.options.positionClass = position ? position : 'toast-top-right';
        toastr.info(`Position class is: '${position}'`, 'Toaster position');
    });
    // Type change and toast
    $('.toastr-btn-type').on('click', (e) => {
        let type = e.target.dataset.type;
        if (!type) type = 'info';
        toastr.options.positionClass = 'toast-top-right';
        toastr[type](`Toastr type class is: '${type}'`, 'Toaster type');
    });
})
