<?php

namespace App\Notifications;

use App\Notifications\Core\Helper\NotificationTemplateHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\VonageMessage;
use Illuminate\Notifications\Notification;

abstract class BaseNotification extends Notification
{
    use Queueable;

    public $auth;

    public $templates;

    public $via;

    public $model;

    public $mailView;

    public $databaseNotificationUrl = null;

    public $mailSubject = null;

    public $databaseNotificationContent;

    public $smsNotificationContent;

    protected $tag;

    public function __construct()
    {
        $this->parseNotification();
    }

    public function via($notifiable)
    {
        return $this->via;
    }


    public function toMail($notifiable)
    {
        $template = $this->template()->mail();
        $content = $template->custom_content ?? $template->default_content;
        return (new MailMessage)
            ->view($this->mailView, [
                'template' => strtr(
                    $content,
                    class_exists($this->tag) ? (new $this->tag($this->model, $this->auth, $notifiable))->notification() : []
                )
            ])
            ->subject($this->mailSubject);
    }

    public function toDatabase($notifiable)
    {
        return [
            "message" => $this->databaseNotificationContent,
            "name" => $notifiable->name,
            "url" => $this->databaseNotificationUrl,
            "notifier_id" => optional($this->auth)->id,
        ];

    }

    public function toVonage($notifiable)
    {
        return (new VonageMessage())
            ->content($this->smsNotificationContent);
    }

    public function template()
    {
        return new NotificationTemplateHelper($this->templates);
    }

    /**
     * This function must assign value to class variable which is needed to send your notification
     */
    abstract public function parseNotification();

}
